/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.block.entity;

import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.minecraft.class_1263;
import net.minecraft.class_1275;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3908;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.block.entity.NameableBlockEntity;
import slimeknights.mantle.fabric.transfer.InventoryStorage;
import slimeknights.mantle.util.ItemStackList;

public abstract class InventoryBlockEntity
extends NameableBlockEntity
implements class_1263,
class_3908,
class_1275,
SidedStorageBlockEntity {
    private static final String TAG_INVENTORY_SIZE = "InventorySize";
    private static final String TAG_ITEMS = "Items";
    private static final String TAG_SLOT = "Slot";
    private class_2371<class_1799> inventory;
    private final boolean saveSizeToNBT;
    protected int stackSizeLimit;
    protected SlottedStackStorage itemHandler;

    public InventoryBlockEntity(class_2591<?> tileEntityTypeIn, class_2338 pos, class_2680 state, class_2561 name, boolean saveSizeToNBT, int inventorySize) {
        this(tileEntityTypeIn, pos, state, name, saveSizeToNBT, inventorySize, 64);
    }

    public InventoryBlockEntity(class_2591<?> tileEntityTypeIn, class_2338 pos, class_2680 state, class_2561 name, boolean saveSizeToNBT, int inventorySize, int maxStackSize) {
        super(tileEntityTypeIn, pos, state, name);
        this.saveSizeToNBT = saveSizeToNBT;
        this.inventory = class_2371.method_10213((int)inventorySize, (Object)class_1799.field_8037);
        this.stackSizeLimit = maxStackSize;
        this.itemHandler = InventoryStorage.of(this, null);
    }

    @Nonnull
    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 direction) {
        return this.itemHandler;
    }

    public class_1799 method_5438(int slot) {
        if (slot < 0 || slot >= this.inventory.size()) {
            return class_1799.field_8037;
        }
        return (class_1799)this.inventory.get(slot);
    }

    public boolean isStackInSlot(int slot) {
        return !this.method_5438(slot).method_7960();
    }

    private void resizeInternal(int size) {
        if (size == this.inventory.size()) {
            return;
        }
        ItemStackList newInventory = ItemStackList.withSize(size);
        for (int i = 0; i < size && i < this.inventory.size(); ++i) {
            newInventory.set(i, (class_1799)this.inventory.get(i));
        }
        this.inventory = newInventory;
    }

    public void resize(int size) {
        this.resizeInternal(size);
        this.setChangedFast();
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public int method_5444() {
        return this.stackSizeLimit;
    }

    public void method_5447(int slot, class_1799 itemstack) {
        if (slot < 0 || slot >= this.inventory.size()) {
            return;
        }
        class_1799 current = (class_1799)this.inventory.get(slot);
        this.inventory.set(slot, (Object)itemstack);
        if (!itemstack.method_7960() && itemstack.method_7947() > this.method_5444()) {
            itemstack.method_7939(this.method_5444());
        }
        if (!class_1799.method_7973((class_1799)current, (class_1799)itemstack)) {
            this.setChangedFast();
        }
    }

    public class_1799 method_5434(int slot, int quantity) {
        if (quantity <= 0) {
            return class_1799.field_8037;
        }
        class_1799 itemStack = this.method_5438(slot);
        if (itemStack.method_7960()) {
            return class_1799.field_8037;
        }
        if (itemStack.method_7947() <= quantity) {
            this.method_5447(slot, class_1799.field_8037);
            this.setChangedFast();
            return itemStack;
        }
        itemStack = itemStack.method_7971(quantity);
        if (this.method_5438(slot).method_7947() == 0) {
            this.method_5447(slot, class_1799.field_8037);
        }
        this.setChangedFast();
        return itemStack;
    }

    public class_1799 method_5441(int slot) {
        class_1799 itemStack = this.method_5438(slot);
        this.method_5447(slot, class_1799.field_8037);
        return itemStack;
    }

    public boolean method_5437(int slot, class_1799 itemstack) {
        if (slot < this.method_5439()) {
            return ((class_1799)this.inventory.get(slot)).method_7960() || itemstack.method_7947() + ((class_1799)this.inventory.get(slot)).method_7947() <= this.method_5444();
        }
        return false;
    }

    public void method_5448() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            this.inventory.set(i, (Object)class_1799.field_8037);
        }
    }

    public boolean method_5443(class_1657 entityplayer) {
        if (this.field_11863 == null || this.field_11863.method_8321(this.field_11867) != this || this.method_11010().method_26204() == class_2246.field_10124) {
            return false;
        }
        return entityplayer.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void method_5435(class_1657 player) {
    }

    public void method_5432(class_1657 player) {
    }

    @Override
    public void method_11014(class_2487 tags) {
        super.method_11014(tags);
        if (this.saveSizeToNBT) {
            this.resizeInternal(tags.method_10550(TAG_INVENTORY_SIZE));
        }
        this.readInventoryFromNBT(tags);
    }

    @Override
    public void saveSynced(class_2487 tags) {
        super.saveSynced(tags);
        if (this.saveSizeToNBT) {
            tags.method_10569(TAG_INVENTORY_SIZE, this.inventory.size());
        }
    }

    @Override
    public void method_11007(class_2487 tags) {
        super.method_11007(tags);
        this.writeInventoryToNBT(tags);
    }

    public void writeInventoryToNBT(class_2487 tag) {
        InventoryBlockEntity inventory = this;
        class_2499 nbttaglist = new class_2499();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            if (inventory.method_5438(i).method_7960()) continue;
            class_2487 itemTag = new class_2487();
            itemTag.method_10567(TAG_SLOT, (byte)i);
            inventory.method_5438(i).method_7953(itemTag);
            nbttaglist.add((Object)itemTag);
        }
        tag.method_10566(TAG_ITEMS, (class_2520)nbttaglist);
    }

    public void readInventoryFromNBT(class_2487 tag) {
        class_2499 list = tag.method_10554(TAG_ITEMS, 10);
        int limit = this.method_5444();
        for (int i = 0; i < list.size(); ++i) {
            class_2487 itemTag = list.method_10602(i);
            int slot = itemTag.method_10571(TAG_SLOT) & 0xFF;
            if (slot >= this.inventory.size()) continue;
            class_1799 stack = class_1799.method_7915((class_2487)itemTag);
            if (!stack.method_7960() && stack.method_7947() > limit) {
                stack.method_7939(limit);
            }
            this.inventory.set(slot, (Object)stack);
        }
    }

    public boolean method_5442() {
        for (class_1799 itemstack : this.inventory) {
            if (itemstack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public SlottedStackStorage getItemHandler() {
        return this.itemHandler;
    }
}

